IF EXISTS (SELECT * FROM SYS.procedures WHERE NAME = 'P_PDV_CONSLD_VD_ROLLBACK')
	BEGIN
		DROP PROCEDURE P_PDV_CONSLD_VD_ROLLBACK
	END

GO
-- EXEC P_PDV_CONSLD_VD_ROLLBACK
CREATE PROCEDURE P_PDV_CONSLD_VD_ROLLBACK  @CD_CTR INT
AS

DECLARE @DT_MOV DATETIME
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_CX INT

SELECT
	@CD_EMP=CD_EMP,
	@CD_FILIAL=CD_FILIAL,
	@CD_CX=CD_CX,
	@DT_MOV=DT_MOV
FROM
	PDV_CONSLD_VD_AUDITORIA
WHERE
	CD_CTR =@CD_CTR

DELETE 
	FROM 
		PDV_CONSLD_VD 
WHERE 
	CD_EMP=@CD_EMP
	AND CD_FILIAL=@CD_FILIAL
	AND CD_CX=@CD_CX
	AND DT_MOV=@DT_MOV

INSERT INTO PDV_CONSLD_VD
	(CD_EMP,
	CD_FILIAL,
	CD_CX,
	DT_MOV,
	NR_CUPOM_INI,
	NR_CUPOM_FIM,
	VLR_VD_LIQ,
	CD_USU,
	DT_CAD,
	DT_ULT_ALT,
	ORIG,
	VALIDADO,
	VL_SERV,
	VL_RECEB,
	NM_ESTACAO_TRABALHO)

SELECT
	CD_EMP,
	CD_FILIAL,
	CD_CX,
	DT_MOV,
	NR_CUPOM_INI,
	NR_CUPOM_FIM,
	VLR_VD_LIQ,
	CD_USU,
	GETDATE(),
	DT_ULT_ALT,
	ORIG,
	VALIDADO,
	VL_SERV,
	VL_RECEB,
	NM_ESTACAO_TRABALHO
FROM
	PDV_CONSLD_VD_AUDITORIA	
WHERE
	CD_CTR=@CD_CTR